unit Sample;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls, Unrar, QComCtrls, DateUtils;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Unrar1: TUnrar;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Unrar1FileProcessing(Sender: TObject;
      hdrData: RARHeaderDataT; status: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  {Unrar1.Languages;}
  Memo1.Lines.Add(BoolToStr(Unrar1.Execute(), true));
end;

procedure TForm1.Unrar1FileProcessing(Sender: TObject;
  hdrData: RARHeaderDataT; status: Integer);
var
  Y, M, D:Word;
  begin
  DecodeDate(hdrData.FileTime, Y, M, D);
  Memo1.Lines.Add(hdrData.FileName+':'+hdrData.Method+
                  'TIME:'+IntToStr(Y)+'-'+IntToStr(M)+'-'+IntToStr(D));
end;

end.
